function [data] = xls2csv()
%This little ditty converts xls or xlsx files into csv files.
%Synatax:   [data] = xls2csv(); 
%Input:     none right now
%Output:    data = the data stored in the xls files, as a cell array.

setappdata(0,'UseNativeSystemDialogs',false)
%get files. Note: currently the filterindex is the filter selected for the file selection.
[filenames,pathname,filterindex] = uigetfile2({'*.xlsx','Excel 2007 files (*.xlsx)';...
    '*.xls','Excel files (*.xls)';},'Open Stack','Multiselect','on');
setappdata(0,'UseNativeSystemDialogs',true)
%make sure filename is a cell array
if ~iscell(filenames)
    filenames = {filenames};
end

%make the output directory
mkdir([pathname],'csv');
%localization for macs
if ispc
    slash = '\';        %Windows directory marker
else
    slash = '/';        %Mac directory marker
end
%Now open the data sets according to the filter used.
parpool
parfor i = 1:size(filenames,2)
    %read excel file
    data{i} = single(xlsread([pathname,filenames{1,i}]));
    %Now save the data to CSV files.
    csv_exp = dataset(data{i});               %to export as a CSV need to make the data a dataset.
    %export(csv_exp,'XLSfile',[[pathname,'csv',slash],[filenames{1,i}(1:end-4),'.xls']]);
    export(csv_exp,'File',[[pathname,'csv',slash],[filenames{1,i}(1:end-4),'.csv']],'delimiter',',')
    %clear data
    csv_exp = [];
end
delete(gcp('nocreate'));